/*
 *  File:		memutils.c
 *  Function:	memory utilities
 *  Author:		Paul Elseth
 *				Copyright (c) 1991, Paul Elseth
 *
 *	Change History:
 *
 *		12/04/91	PBE		created
 */

#ifndef	__MEMUTILS__
#include "memutils.h"
#endif

#ifndef __MEMORY__
#include <memory.h>
#endif
#ifndef __orca__
#include <orca.h>
#endif
#ifndef __GLOBALS__
#include "globals.h"
#endif                            
#ifndef	__OPTIONS__
#include "options.h"
#endif

#pragma noroot


/*
 *	GetNewHandle()
 * 		Allocate a new handle.
 */
short GetNewHandle(long size, Handle *h)
{
	*h = NewHandle(size, gUserID, 0, 0L);

    return toolerror();
}


/*
 *	GetNewPtr()
 * 		Allocate a new pointer.
 */		
short GetNewPtr(long size, Ptr *p)
{
	*p = *NewHandle(size, gUserID, attrFixed, 0L);

    return toolerror();
}


/*
 *	DisposePtr()
 *		Dispose of a pointer.
 */
short DisposePtr(Ptr p)
{
	Handle	h;
    short	err;

    h = FindHandle(p);
    err = toolerror();
	if (err == 0) {
		DisposeHandle(h);
        err = toolerror();
	    }

	return err;
}


/*
 *	DisposeIfHandle()
 *		Dispose a handle if it's valid.
 */
short DisposeIfHandle(Handle h)
{
	short	err;

	CheckHandle(h);
	err = toolerror();
	if (err != 0)
		asm {brk 0xff}
	else
		DisposeHandle(h);

	return toolerror();
}


/*
 *	DisposeIfPtr()
 *		Dispose a ptr if it's valid.
 */
short DisposeIfPtr(Ptr p)
{
	short	err;

	err = DisposePtr(p);
	if (err != 0)
		asm {brk 0xfe}

	return err;
}


/*
 *	HGetState()
 *		Return the current attributes of a handle.
 */
short HGetState(Handle h)
{
	short	attrs;

    asm {
		ldy	#4
		lda	[h],y
        sta	attrs
		}

	return attrs;
}


/*
 *	HSetState()
 *		Set the attributes of a handle.
 */
void HSetState(Handle h, short state)
{
    asm {
        lda state
		ldy	#4
		sta	[h],y
		}
}
